<?xml version="1.0" encoding="UTF-8"?>
<schema xmlns="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
    <title>Schematronvalidatie van PRPM_IN406110NL - Organization Detail Query Response</title>
    <ns uri="urn:hl7-org:v3" prefix="hl7"/>
    <ns uri="http://www.w3.org/2001/XMLSchema-instance" prefix="xsi"/>
    <include href="coreschematron/xml.sch"/>

    <include href="coreschematron/transmission-wrapper.sch"/>
    <include href="coreschematron/controlAct-wrapper.sch"/>

    <pattern is-a="transmission-wrapper" id="PRPM_IN406110NL-wrapper">
        <param name="element" value="hl7:PRPM_IN406110NL"/>
    </pattern>
    
    <pattern is-a="controlAct-wrapper" id="PRPM_IN406110NL-controlAct">
        <param name="element" value="hl7:PRPM_IN406110NL/hl7:ControlActProcess"/>
    </pattern>
    
    <pattern>
        <!-- profileId -->
        <rule context="hl7:PRPM_IN406110NL/hl7:profileId">
            <extends rule="II"/>
            <assert role="error" test="@root='2.16.840.1.113883.2.4.3.11.1' and @extension='810'"
                >In de transmission wrapper moet het element profileId worden gevuld met de waarde '810'</assert>
        </rule>
        <rule context="hl7:PRPM_IN406110NL/hl7:acceptAckCode">
            <extends rule="CS"/>
            <assert role="error" test="@code='NE'">In de transmission wrapper moet het veld acceptAckCode worden gevuld met waarde 'NE'.</assert>
        </rule>
        <rule context="hl7:PRPM_IN406110NL/hl7:attentionLine">
            <assert role="warning" test="not(.)">Het gebruik van attentionLine wordt nog niet gespecificeerd in deze interactie.</assert>
        </rule>
    </pattern>

    <pattern>
        <title>registrationProcess</title>
        <rule context="hl7:registrationProcess/hl7:code">
            <extends rule="CD"/>
            <assert role="error" test="@code='117117' and @codeSystem='2.16.840.1.113883.2.4.15.4'"
                >registrationProcess/code moet '117117' zijn en komen uit codeSystem
                '2.16.840.1.113883.2.4.15.4'</assert>
        </rule>
    </pattern>

    <pattern>
        <title>registrationProcess/subject1/assignedEntity</title>
        <rule context="hl7:registrationProcess/hl7:subject1/hl7:assignedEntity/hl7:id">
            <extends rule="II"/>
            <assert role="warning" test="@root='2.16.528.1.1007.3.3' or (@root='2.16.840.1.113883.2.4.3.11' and @extension='7') or @root='2.16.840.1.113883.2.4.3.11.25' or @root='2.16.840.1.113883.2.4.3.11.10'"
                ><name path=".."/>/<name/> is onbekend (@root='<value-of select="@root"/>' @extension='<value-of select="@extension"/>'). Verwachte waarden zijn '2.16.528.1.1007.3.3' (URA), '2.16.840.1.113883.2.4.3.11' / '7' (Klantenloket), '2.16.840.1.113883.2.4.3.11.25' (GBO/GBP), '2.16.840.1.113883.2.4.3.11.10' (organisatiedelen)</assert>
        </rule>
        <rule context="hl7:registrationProcess/hl7:subject1/hl7:assignedEntity/hl7:code">
            <extends rule="CE"/>
            <assert role="error" test="@nullFlavor='UNK' or @codeSystem='2.16.840.1.113883.2.4.15.1060'"
                >assignedEntity/code moet komen uit '2.16.840.1.113883.2.4.15.1060' (RoleCodeNL -
                zorgaanbiedertypen) of nullFlavor 'UNK' hebben.</assert>
        </rule>
        <rule context="hl7:registrationProcess/hl7:subject1/hl7:assignedEntity/hl7:addr">
            <extends rule="AD"/>
            <assert role="error" test="@nullFlavor='UNK' or @use='PHYS' or @use='PST'"
                >assignedEntity/addr/@use moet een vestigingsadres of postadres zijn óf moet nullFlavor 'UNK' bevatten.</assert>
            <assert role="error" test="@nullFlavor or hl7:city"
                >assignedEntity/addr dient tenminste de plaats te bevatten in element city</assert>
        </rule>
        <rule context="hl7:registrationProcess/hl7:subject1/hl7:assignedEntity/hl7:statusCode">
            <extends rule="CS"/>
            <assert role="error" test="@code='active' or @code='terminated' or @nullFlavor='UNK'"
                >assignedEntity/statusCode moet 'active' of 'terminated' bevatten of nullFlavor 'UNK'.</assert>
            
        </rule>
        <rule context="hl7:registrationProcess/hl7:subject1/hl7:assignedEntity/hl7:effectiveTime">
            <extends rule="IVL_TS"/>
            <assert role="error" test="@nullFlavor='UNK' or hl7:low or hl7:high"
                >assignedEntity/effectiveTime moet nullFlavor='UNK' of tenminste een begindatum in low of einddatum in high hebben.</assert>
        </rule>
        <rule context="hl7:registrationProcess/hl7:subject1/hl7:assignedEntity/hl7:effectiveTime/*">
            <assert role="error" test="local-name(.)='low' or local-name(.)='high'"
                >assignedEntity/effectiveTime mag alleen low of high als subelementen hebben.</assert>
            <assert role="error" test="@value or @nullFlavor='UNK'"
                >assignedEntity/effectiveTime: indien geen waarde bekend is moet nullFlavor 'UNK' gebruikt worden.</assert>
        </rule>

        <rule context="hl7:registrationProcess/hl7:subject1/hl7:assignedEntity/hl7:representedOrganization/hl7:id">
            <extends rule="II"/>
            <assert role="error" test="@root='2.16.840.1.113883.2.4.6.5' and @extension='2'"
                >representedOrganization is het ministerie van VWS voor zorgaanbieders: @root='2.16.840.1.113883.2.4.6.5' en @extension='2'.</assert>
        </rule>

        <rule context="hl7:registrationProcess/hl7:subject1/hl7:assignedEntity/hl7:subjectOf">
            <assert role="error" test="not(.)"
                >assignedEntity/subjectOf/note mag niet gebruikt worden.</assert>
        </rule>
        
        <rule context="hl7:registrationProcess/hl7:subject1/hl7:assignedEntity/hl7:part">
            <assert role="error" test="not(.)">assignedEntity/part mag niet gebruikt worden.</assert>
        </rule>
        
        <rule context="hl7:registrationProcess/hl7:subject1/hl7:assignedEntity/hl7:partOf">
            <assert role="error" test="not(.)">assignedEntity/partOf mag niet gebruikt worden.</assert>
        </rule>

    </pattern>

    <pattern>
        <title>registrationProcess/subject1/assignedEntity/assignedPrincipalOrganization</title>
        <rule
            context="hl7:registrationProcess/hl7:subject1/hl7:assignedEntity/hl7:assignedPrincipalOrganization/hl7:affiliate">
            <assert role="error" test="not(.)"
                >assignedPrincipalOrganization/affiliate mag niet gebruikt worden.</assert>
        </rule>
    </pattern>
    
    <pattern>
        <title>ControlActProcess/reasonOf</title>
        <rule context="hl7:reasonOf/hl7:code">
            <extends rule="CD"/>
        </rule>
    </pattern>
    
</schema>
